% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{FAST_structure}
\alias{FAST_structure}
\title{(Varitional) ICM-EM algorithm for implementing FAST model with structurized parameters}
\usage{
FAST_structure(
  XList,
  AdjList,
  q = 15,
  fit.model = c("poisson", "gaussian"),
  parameterList = NULL
)
}
\arguments{
\item{XList}{an M-length list consisting of multiple matrices with class dgCMatrix or matrix that specify the count/log-count gene expression matrix for each data batch used for FAST model.}

\item{AdjList}{an M-length list of sparse matrices with class dgCMatrix, specify the adjacency matrix used for intrisic CAR model in FAST. We provide this interface for those users who would like to define the adjacency matrix by themselves.}

\item{q}{an optional integer, specify the number of low-dimensional embeddings to extract in FAST}

\item{fit.model}{an optional string, specify the version of FAST to be fitted. The Gaussian version models the log-count matrices while the Poisson verions models the count matrices; default as gaussian due to fastter computation.}

\item{parameterList}{an optional list, specify other parameters in FAST model; see \code{\link{model_set_FAST}} for other paramters. The default is \code{NULL} that means the default parameters produced by \code{\link{model_set_FAST}} is used.}
}
\value{
return a list including the following components: (1) hV: an M-length list consisting of spatial embeddings in FAST; (2) nu: the estimated intercept vector; (3) Psi: the estimated covariance matrix; (4) W: the estimated shared loading matrix; (5) Lam: the estimated covariance matrix of error term; (6): ELBO: the ELBO value when algorithm convergence; (7) ELBO_seq: the ELBO values for all itrations.
}
\description{
(Varitional) ICM-EM algorithm for implementing FAST model with structurized parameters
}
\details{
None
}
\references{
None
}
\seealso{
\code{\link{FAST_run}}, \code{\link{FAST}}, \code{\link{model_set_FAST}}
}
