% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{feature}
\alias{feature}
\title{Create an Object Feature}
\usage{
feature(expr)
}
\arguments{
\item{expr}{expression}
}
\value{
a Q7 feature
}
\description{
Create an Object Feature
}
\examples{

Type1 <- type(function(num){})

hasMagic <- feature({
    change_number <- function(){
        num + 1
    }
})

myType1 <- Type1(1) \%>\% hasMagic()
myType1$change_number()


# Use S3 method dispatch for different behaviors
hasMagic <- feature_generic(s3 = "hasMagic")

hasMagic.Type1 <- feature({
    change_number <- function(){
        num + 1
    }
})

hasMagic.Type2 <- feature({
    change_number <- function(){
        num - 1
    }
})

Type1 <- type(function(num){},
              s3 = "Type1") \%>\%
    hasMagic()

Type2 <- type(function(num){},
              s3 = "Type2") \%>\%
    hasMagic()

myType1 <- Type1(1)
myType1$change_number()

myType2 <- Type2(1)
myType2$change_number()

}
