% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PayoffMatrix_QPD.R
\name{PayoffMatrix_QPD}
\alias{PayoffMatrix_QPD}
\title{Quantum Prisoner's Dilemma game: Payoff Matrix}
\usage{
PayoffMatrix_QPD(moves, w, x, y, z)
}
\arguments{
\item{moves}{a list of matrices}

\item{w}{a number}

\item{x}{a number}

\item{y}{a number}

\item{z}{a number}
}
\value{
The payoff matrices for the two players as two elements of a list.
}
\description{
This function generates the payoff matrix for the Quantum Prisoner's Dilemma game . \code{moves} is a list of the possible strategies for each of the players and \code{w, x, y, z} are the payoffs for the players corresponding to the choices available to them with the chain of inequalities, \code{z>w>x>y}.
This function also plots the probability distribution plots of the qubits for all the possible combinations of the strategies of the players.
}
\examples{
init()
moves <- list(Q$I2, sigmaX(Q$I2), Hadamard(Q$I2), sigmaZ(Q$I2))
PayoffMatrix_QPD(moves, 3, 1, 0, 5)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0004076.pdf}\cr
}
