% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QDuelsPlot2.R
\name{QDuelsPlot2}
\alias{QDuelsPlot2}
\title{Quantum Two Person Duel game}
\usage{
QDuelsPlot2(Psi, n, a, b, alpha1, alpha2, beta1, beta2)
}
\arguments{
\item{Psi}{a vector representing the initial quantum state}

\item{n}{an integer}

\item{a}{a number}

\item{b}{a number}

\item{alpha1}{a number}

\item{alpha2}{a number}

\item{beta1}{a number}

\item{beta2}{a number}
}
\value{
No return value, plots Alice's and Bob's expected payoffs as functions of the number of rounds \code{n} played in a repeated quantum duel.
}
\description{
This function helps us to plot Alice's and Bob's expected payoffs as functions of the number of rounds \code{n} played in a repeated quantum duel. \code{Psi} is the initial state of the quantum game, \code{n} is the number of rounds, \code{a} is the probability of Alice missing the target, \code{b} is the probability of Bob missing the target, and
\code{alpha1, alpha2, beta1, beta2} are arbitrary phase factors that lie in -pi to pi that control the outcome of a poorly performing player.
}
\examples{
init()
QDuelsPlot2(Q$Q01, 10, 0.66666, 0.5, -pi/2, pi/4, 0.6, 0.4)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0305058.pdf}\cr
}
