% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bnk_func.R
\name{Bnk_func}
\alias{Bnk_func}
\title{Generate biquadratic kernel weights for a univariate variable}
\usage{
Bnk_func(x0k, Xk, bw.bnk)
}
\arguments{
\item{x0k}{Numeric scalar. One univariate covariate value of interest 
from one observation.}

\item{Xk}{Numerical vector. The vector of the same covariate from observations}

\item{bw.bnk}{The bandwith scalar parameter.}
}
\value{
This function returns a list of kernel weights with the same length of input \code{Xk}.
}
\description{
This is the biquadratic kernel function, that weights
observations by their distances to the target observation.
}
\note{
This function is widely used for generating kernel weights for 
nonparametrically estimating conditional survival functions. See 
Section 2.3 of \insertCite{wang2009locally}{QTOCen}.
}
\examples{
 
Bnk_func(x0k=0, Xk=c(-5:5), bw.bnk=10)

}
\references{
\insertRef{wang2009locally}{QTOCen}
}
