% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simuJLSDdata.R
\name{simJLSDdata}
\alias{simJLSDdata}
\title{Function to generate simulation data from a sequentially randomized
 experiment designed in \insertCite{jiang2017estimation}{QTOCen}}
\usage{
simJLSDdata(n, case = "a", s_Diff_Time = 1, C_max = 5,
  Censored = TRUE, fix_x0_value = NULL)
}
\arguments{
\item{n}{sample size}

\item{case}{string. One of {"a", "b", "c"}, corresponding to three models.}

\item{s_Diff_Time}{Numeric. Default is 1. This is the length of time between two stages of treatment}

\item{C_max}{Numeric. Default is 5. This the upper bound of the uniform distribution of the 
censoring time variable. Changing this value shifts the overall censoring rate easily.}

\item{Censored}{Boolean. Default is TRUE. Whether the data has censoring or not. If TRUE, all survival time
would not be censored at all in the returned data.}

\item{fix_x0_value}{Numeric. Default is Null. If supplied, it will generate simulated 
data with a fixed value, \code{fix_x0_value}, of the univariate baseline covarate.}
}
\value{
This function returns a data.frame with simulated subject trajectories.
\itemize{
 \item{\code{x0}}{ the baseline covariate, always observable at relative time point 0; }
 \item{\code{a0}}{ the observed first-stage treatment level at relative time point 0;}
 \item{\code{x1}}{ an updated covariate observable to the relative time point 
                   \code{s_Diff_Time}, when the 
                   a second stage treatment is scheduled}
 \item{\code{a1}}{ the observed second-stage treatment level at relative time point \code{s_Diff_Time}.}
}
}
\description{
Function to generate simulation data from a sequentially randomized
 experiment designed in \insertCite{jiang2017estimation}{QTOCen}
}
\details{
This generative model is proposed in \insertCite{jiang2017estimation}{QTOCen}, Section 5, the second example. 
It uniformly defined three
sets of conditional distributions of the survival times given the observable
covariates at each stage within the same framework.

All three models satisfy the independent censoring assumption.
}
\examples{
dataA <- simJLSDdata(500,case="a")
dataB <- simJLSDdata(500,case="b")
dataC <- simJLSDdata(500,case="c")

}
\references{
\insertRef{jiang2017estimation}{QTOCen}
}
