% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brc_qol.R
\name{brc_qol}
\alias{brc_qol}
\title{Calculates the domain-based scale scores using the data of QLQ-BR23}
\usage{
brc_qol(x)
}
\arguments{
\item{x}{A data frame with ID, BR_Q31,BR_Q32,...,BR_Q53 columns along with other columns if data is available.}
}
\value{
A data frame by replacing the columns 'BR_Q31','BR_Q32',...,'BR_Q53' by the domain-based scale scores.
}
\description{
Creates a dataset containing the domain-based scale scores using
the data from QLQ-BR23
}
\details{
brc_miss function inputs either a dataset containing missing information, represented as,
9 or 99 or NA or a data not containing any missing information. It extracts only the columns
named 'BR_Q31','BR_Q32',...,'BR_Q53' and replaces the missing data with the minimum value of the particular question.

Using each of the 30 columns, the Raw Score is computed, and one column is obtained containing
the Raw Score for each patient.

Further, using each of the Raw Scores, three domain-based Scale Scores are computed,
they are, Global Scales Score, Functional Scales Score and Symptoms Scales Score.

Thus, the columns 'BR_Q31','BR_Q32',...,'BR_Q53' are replaced by the domain-based scale scores,
which is obtained as the output.

brc_qol(x)

1) Subject ID column should be named as 'ID'.

2) Each question column should be named as 'BR_Q31' for data from question 31,
'BR_Q32' for data from question 32, and so on until 'BR_Q53' for data from question 53

3) Data may contain more variables, such as, Age, Gender, etc.

x - A data frame with ID, BR_Q31,BR_Q32,...,BR_Q53 columns along with other columns if data
is available.

rs - A matrix containing the Raw Score computed using all BR_Q31 to BR_Q53 data for each
patient. The RS(a) function is used in this case.

fs - A matrix containing the Functional Scale Scores computed using all BR_Q31 to BR_Q53
data for each patient. The FS(a,b) function is used in this case.

ss - A matrix containing the Global Scale Scores computed using all BR_Q31 to BR_Q53
data for each patient. The SS(a,b) function is used in this case.

final_data - A data frame formed by replacing the columns 'BR_Q31','BR_Q32',...,'BR_Q53' by
the domain-based scale scores.
}
\examples{
##
data(brc_df)
brc_qol(brc_df)
data(brc_df_miss)
brc_qol(brc_df_miss)
##

}
\references{
QoLMiss: Package for Repeatedly measured Quality of Life of Cancer Patients Data
}
\seealso{
https://github.com/apstat/QoLMiss-Package
}
\author{
Atanu Bhattacharjee and Ankita Pal
}
