% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QregBB.R
\name{getNPPIblksizesQR}
\alias{getNPPIblksizesQR}
\title{Chooses block sizes for MBB, ETBB, SMBB, and SETBB via the NPPI for quantile regression}
\usage{
getNPPIblksizesQR(Y, X, tau, min.in.JAB = 100)
}
\arguments{
\item{Y}{the vector of response values.}

\item{X}{the design matrix (including a column of ones for the intercept).}

\item{tau}{the quantile of interest.}

\item{min.in.JAB}{the minimum number of Monte-Carlos draws desired in each jackknife draw}
}
\value{
Returns a list of the NPPI-selected block sizes for the MBB, SMBB, ETBB, and SETBB.
}
\description{
Chooses block sizes for MBB, ETBB, SMBB, and SETBB via the NPPI for quantile regression
}
\details{
This function is based on the nonparametric plug-in (NPPI) method discussed in Lahiri (2003), which makes use of the jackknife-after-bootstrap (JAB).
}
\examples{
# generate some data and use NPPI to choose block sizes for MBB, SMBB, ETBB, and SETBB.
n <- 50
X1 <- arima.sim(model=list(ar=c(.7,.1)),n)
X2 <- arima.sim(model=list(ar=c(.2,.1)),n)
e <- arima.sim(model=list(ar=c(.7,.1)),n)
Y <- X1 + e
X <- cbind(rep(1,n),X1,X2)

blksize.out <- getNPPIblksizesQR(Y,X,tau=.5)
blksize.out
}
\references{
Gregory, K. B., Lahiri, S. N., & Nordman, D. J. (2018). A smooth block bootstrap for quantile regression with time series. \emph{The Annals of Statistics}, 46(3), 1138-1166.

Lahiri, S. N. (2003). Resampling Methods for Dependent Data. Springer, New York.
}
