% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tqDist.r
\name{TQDist}
\alias{TQDist}
\alias{TQAE}
\title{Wrapper for tqDist}
\usage{
TQDist(trees)

TQAE(trees)
}
\arguments{
\item{trees}{List of phylogenetic trees, of class \code{list} or
\code{\link[ape:read.tree]{multiPhylo}}.}
}
\value{
\code{TQDist()} returns the quartet distance between each pair of trees.

\code{TQAE()} returns the number of resolved quartets in agreement between
each pair of trees ("A" in Brodal \emph{et al}. 2013) and the number of quartets
that are unresolved in both trees ("E" in Brodal \emph{et al}. 2013).
}
\description{
\code{TQDist()} and \code{TQAE()} are convenience functions that writes a list of
trees to text files that can be processed by the C implementation of tqDist
\insertCite{Sand2014}{Quartet}.
tqDist is then called, and the temporary file is deleted when analysis is
complete.
}
\details{
Quartets can be resolved in one of five ways, which
\insertCite{Brodal2013;textual}{Quartet} and
\insertCite{Holt2014;textual}{Quartet} distinguish using the letters A-E,
and \insertCite{Estabrook1985;textual}{Quartet} refer to as:

\describe{
\item{A}{\emph{s} = resolved the \strong{s}ame in both trees;}
\item{B}{\emph{d} = resolved \strong{d}ifferently in both trees;}
\item{C}{\emph{r1} = \strong{r}esolved only in tree \strong{1};}
\item{D}{\emph{r2} = \strong{r}esolved only in tree \strong{2} (the comparison tree);}
\item{E}{\emph{u} = \strong{u}nresolved in both trees.}
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=CompareQuartets]{CompareQuartets()}}, \code{\link[=QuartetStatus]{QuartetStatus()}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
