% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_n.R
\name{optimize_n}
\alias{optimize_n}
\title{Optimize the n parameter during denovo stacks assembly}
\usage{
optimize_n(nequalsMminus1 = NULL, nequalsM = NULL, nequalsMplus1 = NULL)
}
\arguments{
\item{nequalsMminus1}{Path to the input vcf file for a run when n=M-1}

\item{nequalsM}{Path to the input vcf file for a run when n=M}

\item{nequalsMplus1}{Path to the input vcf file for a run when n=M+1}
}
\value{
A dataframe showing the number of SNPs and loci retained across filtering levels for each n value
}
\description{
This function requires the path to stacks vcf file(s) as input.
There are slots for varying the n parameter across M-1, M, and M-1 (as recommended by Paris et al. 2017).
After running stacks with each of the n options, plug the output vcf files into this
function to visualize the effect of varying m on number of SNPs and loci built to
recognize which value optimizes the n parameter for your dataset at the 'R80' cutoff (Paris et al. 2017).
}
\examples{
optimize_n(nequalsM =
system.file("extdata","nequalsm.vcf.gz",package="RADstackshelpR",mustWork=TRUE))
}
