% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixjson.R
\name{mixjson}
\alias{mixjson}
\alias{write_mix_json}
\alias{read_mix_json}
\title{Write and Read a Mixture Object with JSON}
\usage{
write_mix_json(mix, con, ...)

read_mix_json(con, ..., rescale = TRUE)
}
\arguments{
\item{mix}{A mixture object to be saved to JSON.}

\item{con}{A connection specifying where the JSON will be written
to or read.}

\item{...}{Additional arguments passed to the
\code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}} and
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} function for writing and
reading, respectively.}

\item{rescale}{A logical value indicating whether to rescale the
mixture weights so that they sum to 1. Defaults to \code{TRUE}.}
}
\value{
The \code{write_mix_json} function does not return a value while
the \code{read_mix_json} returns the mixture object stored in the
connection specified.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

These functions write and read a mixture object in the JSON format.
}
\details{
The mixture objects are written or read from the connection
\code{con}, which can be a character string specifying a file
path or a connection object as detailed in
\code{\link[base:connections]{base::connections()}}.

When writing mixture objects as JSON it is strongly recommended to
explicitly set the number of digits (argument \code{digits}) to be
used for the numerical representation in order to control the
accuracy of the JSON representation of the mixture object. If the
mixture object inherits from the \code{"EM"} class (as is the
case when the mixture is created using the
\code{\link[=mixfit]{mixfit()}} function), then the mixture object
will be cast to a simple mixture object such that diagnostics
from the \code{"EM"} fitting procedure are dropped from the
object. For easier readability the user is encouraged to set the
argument \code{pretty=TRUE}, which is passed to the
\code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}} function and makes the output more
human readable.

Note that when reading in mixture objects, then these are not
necessarily equal to the mixtures passed to the \code{write_mix_json}
function. This is a consequence of the limited precision of the
textual representation as defined by the \code{digits} argument.
}
\examples{
\dontrun{
nm <- mixnorm(rob = c(0.2, 0, 2), inf = c(0.8, 2, 2), sigma = 5)

write_mix_json(nm, "normal_mixture.json", pretty=TRUE, digits=1)

mix <- read_mix_json("normal_mixture.json")
}
}
\seealso{
Other mixdist: 
\code{\link{mix}},
\code{\link{mixbeta}()},
\code{\link{mixcombine}()},
\code{\link{mixgamma}()},
\code{\link{mixmvnorm}()},
\code{\link{mixnorm}()},
\code{\link{mixplot}}
}
\concept{mixdist}
