% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est-c.r
\docType{package}
\name{RCAL-package}
\alias{RCAL-package}
\alias{RCAL}
\title{RCAL: Regularized calibrated estimation}
\description{
Regularized calibrated estimation for causal inference and missing-data problems with high-dimensional data.
}
\details{
The R package \code{RCAL} - version 2.0 can be used for two main tasks:
\itemize{
  \item to estimate the mean of an outcome in the presence of missing data,
  \item to estimate the average treatment effects (ATE) and local average treatment effects (LATE) in causal inference.
}
There are 3 high-level functions provided for the first task:
\itemize{
  \item \code{mn.nreg}: inference using non-regularized calibrated estimation,
  \item \code{mn.regu.cv}: inference using regularized calibrated estimation based on cross validation,
  \item \code{mn.regu.path}: inference using regularized calibrated estimation along a regularization path. 
}
The first function \code{mn.nreg} is appropriate only in relatively low-dimensional settings,
whereas the functions \code{mn.regu.cv} and \code{mn.regu.path} are designed to deal with high-dimensional data (namely, 
the number of covariates close to or greater than the sample size). 
In parallel, there are 3 functions for estimating the average treatment effect in the second task, \code{ate.nreg}, \code{ate.regu.cv}, and \code{ate.regu.path}.
These functions can also be used to perform inference for the average treatment effects on the treated or on the untreated.
Currently, the treatment is assumed to be binary (i.e., untreated or treated). There are also 3 functions for estimating the local average treatment effect using instrumental variables, 
\code{late.nreg}, \code{late.regu.cv}, and \code{late.regu.path}. Currently both the treatment and instrumental variable are assumed to be binary. Extensions to multi-valued treatments and instrumental variables will be incorporated in later versions. 

The package also provides lower-level functions, including \code{glm.nreg} to implement non-regularized M-estimation and \code{glm.regu} to 
implement Lasso regularized M-estimation for fitting generalized linear models currently with continuous or binary outcomes. 
The latter function \code{glm.regu} uses an active-set descent algorithm, which enjoys a finite termination property 
for solving least-squares Lasso problems. 

See the the vignettes for more details.
}
