% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est-c.r
\name{late.nreg}
\alias{late.nreg}
\title{Model-assisted inference for local average treatment effects without regularization}
\usage{
late.nreg(y, tr, iv, fx, gx, hx, arm = 2, d1 = NULL, d2 = NULL,
  ploss = "cal", yloss = "gaus", off = NULL)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} vector of observed outcomes.}

\item{tr}{An \eqn{n} x \eqn{1} vector of treatment indicators (=1 if treated or 0 if untreated).}

\item{iv}{An \eqn{n} x \eqn{1} vector of instruments (0 or 1).}

\item{fx}{An \eqn{n} x \eqn{p} matix of covariates, used in the instrument propensity score model.}

\item{gx}{An \eqn{n} x \eqn{q_1} matix of covariates, used in the treatment regression models.}

\item{hx}{An \eqn{n} x \eqn{q_2} matix of covariates, used in the outcome regression models.}

\item{arm}{An integer 0, 1 or 2 indicating whether \eqn{\theta_0}, \eqn{\theta_1} or both are computed; see \strong{Details} for \code{\link{late.aipw}}.}

\item{d1}{Degree of truncated polynomials of fitted values from treatment regression to be included as regressors in the outcome regression (NULL: no adjustment, 0: piecewise constant, 1: piecewise linear etc..).}

\item{d2}{Number of knots of fitted values from treatment regression to be included as regressors in the outcome regression, with knots specified as the \eqn{i}/(\code{d2}+1)-quantiles for \eqn{i}=1,...,\code{d2}.}

\item{ploss}{A loss function used in instrument propensity score estimation (either "ml" for likelihood estimation or "cal" for calibrated estimation).}

\item{yloss}{A loss function used in outcome regression (either "gaus" for continuous outcomes or "ml" for binary outcomes).}

\item{off}{A \eqn{2} x \eqn{1} vector of offset values (e.g., the true values in simulations) used to calculate the z-statistics from augmented IPW estimation.}
}
\value{
\item{ips}{A list containing the results from fitting the instrument propensity score models by \code{\link{glm.nreg}}.}
\item{mfp}{An \eqn{n} x \eqn{2} matrix of fitted instrument propensity scores for \code{iv}=0 (first column) and \code{iv}=1 (second column).}
\item{tps}{A list containing the results from fitting the treatment regression models by \code{\link{glm.nreg}}.}
\item{mft}{An \eqn{n} x \eqn{2} matrix of fitted treatment regression models for \code{iv}=0 (first column) and \code{iv}=1 (second column).}
\item{or}{A list containing the results from fitting the outcome regression models by \code{\link{glm.nreg}}.}
\item{mfo}{An \eqn{n} x \eqn{4} matrix of fitted outcome regression models for for \code{iv}=0, \code{tr}=0 (first column), \code{iv}=0, \code{tr}=1 (second column), \code{iv}=1, \code{tr}=0 (third column) and  \code{iv}=1, \code{tr}=1 (fourth column). Two columns are set to \code{NA} if \code{arm}=0 or 1.}
\item{est}{A list containing the results from augmented IPW estimation by \code{\link{late.aipw}}.}
}
\description{
This function implements model-assisted inference for local average treatment effects,
using non-regularized calibrated estimation.
}
\details{
For ploss="cal", calibrated estimation of the instrument propensity score (IPS) and weighted likelihood estimation of the treatment and outcome regression models are performed, similarly as in Sun and Tan (2020), but without regularization. 
See also \strong{Details} for \code{\link{mn.nreg}}.
}
\examples{
data(simu.iv.data)
n <- dim(simu.iv.data)[1]
p <- dim(simu.iv.data)[2]-3

y <- simu.iv.data[,1]
tr <- simu.iv.data[,2]
iv <- simu.iv.data[,3]
x <- simu.iv.data[,3+1:p]
x <- scale(x)

# include only 10 covariates
x2 <- x[,1:10]

late.cal <- late.nreg(y, tr, iv, fx=x2, gx=x2, hx=x2, arm=2, d1=1, d2=3,
                       ploss="cal", yloss="gaus")

matrix(unlist(late.cal$est), ncol=2, byrow=TRUE, 
dimnames=list(c("ipw", "or", "est", "var", "ze", 
 "late.est", "late.var", "late.ze"), c("theta1", "theta0")))

}
\references{
Tan, Z. (2006) Regression and weighting methods for causal inference using instrumental variables, Journal of the American Statistical Association, 101, 1607–1618.

Sun, B. and Tan, Z. (2020) High-dimensional model-assisted inference for local average treatment effects with instrumental variables, arXiv:2009.09286.
}
