% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvb.R
\name{CVb}
\alias{CVb}
\title{Critical values for CIs based on a biased Gaussian estimator.}
\usage{
CVb(B, alpha = 0.05)
}
\arguments{
\item{B}{Maximum bias, vector of non-negative numbers.}

\item{alpha}{Determines CI level, \eqn{1-\alpha}{1-alpha}. Scalar between 0
and 1.}
}
\value{
Vector of critical values, one for each value of maximum bias
    supplied by \code{B}.
}
\description{
Computes the critical value \eqn{cv_{1-\alpha}(B)}{cv_{1-alpha}(B)} such that
the confidence interval \eqn{X\pm cv_{1-\alpha}(B)}{X +/- cv_{1-alpha}(B)}
has coverage \eqn{1-\alpha}{1-alpha}, where the estimator \eqn{X} is normally
distributed with variance equal to \eqn{1} and maximum bias at most \eqn{B}.
}
\examples{
## 90\% critical value:
CVb(B = 1, alpha = 0.1)
## Usual 95\% critical value
CVb(0)
## Returns vector with 3 critical values
CVb(B = c(0, 0.5, 1), alpha = 0.05)
}
