% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.types.R
\docType{class}
\name{adpsType}
\alias{adpsType}
\title{adpsType R6 class.}
\format{
An \code{\link[R6]{R6Class}} generator object.
}
\description{
adpsType R6 class.

adpsType R6 class.
}
\details{
Contains \code{matrix} of amplification data. Must have three columns: \describe{
\item{cyc}{PCR cycle at which data
point was collected (every cycle must have unique number).}
\item{tmp}{temperature in degrees Celsius at the time of measurement (optional).}
\item{fluor}{raw fluorescence intensity measured.}} Inherits:
\link{rdmlBaseType}.
}
\section{Initialization}{
 \preformatted{adpsType$new(fpoints)}
}

\section{Fields}{
 \describe{
  \item{\code{fpoints}}{\link[checkmate]{assertMatrix}. Matrix with amplification data
  points.}
  }
}

\examples{
#cycles
cyc <- c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
34, 35, 36, 37, 38, 39, 40)
#fluorescence
fluo <- c(2.0172, 2.0131, 2.0035, 2, 2.0024, 2.0056, 2.0105, 2.0179,
2.0272, 2.0488, 2.0922, 2.1925, 2.3937, 2.7499, 3.3072, 4.0966,
5.0637, 6.0621, 7.0239, 7.8457, 8.5449, 9.1282, 9.6022, 9.9995,
10.2657, 10.4989, 10.6813, 10.8209, 10.9158, 10.9668, 11.0053,
11.0318, 11.0446, 11.044, 11.0052, 10.9671, 10.9365, 10.9199,
10.897, 10.8316)
#temperature
temp <- c(55, 55, 55, 55, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55,
55, 55, 55, 55, 55, 55, 55, 55, 56, 55, 55, 55, 55, 55, 55, 55,
55, 55, 55, 55, 55, 55, 55, 55, 55)

#combine all variables into a proper object
data <- data.frame(cyc = cyc, tmp = temp, fluor = fluo)

#create adps object
adpsType$new(data)

#create adps object without temperature data
adpsType$new(data[, -2])
}
\section{Super class}{
\code{\link[RDML:rdmlBaseType]{RDML::rdmlBaseType}} -> \code{adpsType}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-adpsType-new}{\code{adpsType$new()}}
\item \href{#method-adpsType-.asXMLnodes}{\code{adpsType$.asXMLnodes()}}
\item \href{#method-adpsType-clone}{\code{adpsType$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="copy"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-copy'><code>RDML::rdmlBaseType$copy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="print"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-print'><code>RDML::rdmlBaseType$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-adpsType-new"></a>}}
\if{latex}{\out{\hypertarget{method-adpsType-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{adpsType$new(fpoints)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-adpsType-.asXMLnodes"></a>}}
\if{latex}{\out{\hypertarget{method-adpsType-.asXMLnodes}{}}}
\subsection{Method \code{.asXMLnodes()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{adpsType$.asXMLnodes(node.name)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-adpsType-clone"></a>}}
\if{latex}{\out{\hypertarget{method-adpsType-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{adpsType$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
