% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_game_items.R
\name{get_game_items}
\alias{get_game_items}
\title{Dota Items}
\usage{
get_game_items(dota_id = 570, language = "en", key = NULL)
}
\arguments{
\item{dota_id}{Can take one of three values.

\itemize{
 \item 570 - Dota 2 (default)
 \item 816 - Dota 2 Internal Test
 \item 205790 - Dota 2 Beta Test
}}

\item{language}{The ISO639-1 language code for returning all the information in the corresponding
language. If the language is not supported, english will be returned. For a complete list of the
ISO639-1 language codes please visit \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.}

\item{key}{The api key obtained from Steam. If you don't have one please visit
\url{https://steamcommunity.com/dev} in order to do so. For instructions on the correct way
to use this key please visit \url{https://github.com/LyzandeR/RDota2} and check the readme file.
You can also see the examples. A key can be made available to all the functions by using
\code{key_actions}. The key argument in individual functions should only be used in case the
user needs to work with multiple keys.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
Dota Items.
}
\details{
A list will be returned that contains three elements. The content, the url and the response
received from the api.

The content element of the list contains a data.frame with all the items. Each row of the
data.frame is an item and the following columns are included:

\itemize{
  \item \strong{id:} Item's ID.
  \item \strong{name:} Item's tokenised name.
  \item \strong{cost:} Item's in-game cost.
  \item \strong{secret_shop:} Boolean. Whether it is sold in the secret shop.
  \item \strong{side_shop:} Boolean. Whether it is sold in the side shop.
  \item \strong{recipe:} Boolean. Whether it is a recipe.
  \item \strong{localized_name:} Localised name of item.
}
}
\section{Steam API Documentation}{

 \url{https://wiki.teamfortress.com/wiki/WebAPI/GetGameItems}
}
\examples{
\dontrun{
get_game_items()
get_game_items(dota_id = 570, language = 'en', key = NULL)
get_game_items(dota_id = 570, language = 'en', key = 'xxxxxxxxxxx')
}

}

