% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds2dd_detailed.R
\name{guess_time_only_filter}
\alias{guess_time_only_filter}
\title{Try at determining which are true time only variables}
\usage{
guess_time_only_filter(
  data,
  validate = FALSE,
  sel.pos = "[Tt]i[d(me)]",
  sel.neg = "[Dd]at[eo]"
)
}
\arguments{
\item{data}{data set}

\item{validate}{flag to output validation data. Will output list.}

\item{sel.pos}{Positive selection regex string}

\item{sel.neg}{Negative selection regex string}
}
\value{
character vector or list depending on `validate` flag.
}
\description{
This is just a try at guessing data type based on data class and column names
hoping for a tiny bit of naming consistency. R does not include a time-only
data format natively, so the "hms" class from `readr` is used. This
has to be converted to character class before REDCap upload.
}
\examples{
data <- redcapcast_data
data |> guess_time_only_filter()
data |>
  guess_time_only_filter(validate = TRUE) |>
  lapply(head)
}
