% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds2dd_detailed.R
\name{parse_data}
\alias{parse_data}
\title{Helper to auto-parse un-formatted data with haven and readr}
\usage{
parse_data(
  data,
  guess_type = TRUE,
  col_types = NULL,
  locale = readr::default_locale(),
  ignore.vars = "cpr",
  ...
)
}
\arguments{
\item{data}{data.frame or tibble}

\item{guess_type}{logical to guess type with readr}

\item{col_types}{specify col_types using readr semantics. Ignored if guess_type is TRUE}

\item{locale}{option to specify locale. Defaults to readr::default_locale().}

\item{ignore.vars}{specify column names of columns to ignore when parsing}

\item{...}{ignored}
}
\value{
data.frame or tibble
}
\description{
Helper to auto-parse un-formatted data with haven and readr
}
\examples{
mtcars |>
  parse_data() |>
  str()
}
