% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computing-functions.R
\name{compute_redi}
\alias{compute_redi}
\title{Compute REDI for a specific input}
\usage{
compute_redi(data, coef = 0.1)
}
\arguments{
\item{data}{A tibble or data frame, containing an \code{Input} column (with the
Date format) and an \code{Output} column. A simple vector of workload values,
pre-sorted by chronological order, can also be provided.}

\item{coef}{A number corresponding to the lambda coefficient, controlling the
decay of the exponential weights.}
}
\value{
A number, corresponding to the REDI value at the last \code{Input} time,
computed over the whole period.
}
\description{
Compute REDI for a specific input
}
\examples{
data <- simu_db()
compute_redi(data = data, coef = 0.1)
}
