% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesise_data.R
\name{synthesise_data}
\alias{synthesise_data}
\alias{synthesize_data}
\title{Synthesise data from marginal distributions}
\usage{
synthesise_data(marginals, correlation_matrix = NULL, ...)

synthesize_data(marginals, correlation_matrix = NULL, ...)
}
\arguments{
\item{marginals}{an object of class RESIDE}

\item{correlation_matrix}{Correlation Matrix
see \code{\link{export_empty_cor_matrix}} and
\code{\link{import_cor_matrix}}, Default: NULL}

\item{...}{Additional parameters currently none are used.}
}
\value{
a data frame of simulated data
}
\description{
Allows the synthesis of data from marginal
distributions obtained from a Trusted Research Environment (TRE)
}
\details{
This function will synthesise a dataset from marginals imported
using \code{\link{import_marginal_distributions}}.
By default the dataset will not contain correlations,
however user specified correlations can be added using
the \code{correlation_matrix} parameter,
see \code{\link{export_empty_cor_matrix}} and
\code{\link{import_cor_matrix}} for more details.
}
\examples{
\dontrun{
   marginals <- import_marginal_distributions()
   df <- synthesise_data(marginals)
}
}
\seealso{
\code{\link{export_empty_cor_matrix}}
\code{\link{import_cor_matrix}}
}
