% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gan-trainer.R
\name{GAN_update_plot}
\alias{GAN_update_plot}
\title{GAN_update_plot}
\usage{
GAN_update_plot(data, dimensions = c(1, 2), synth_data, epoch, main = NULL)
}
\arguments{
\item{data}{Real data to be plotted}

\item{dimensions}{Which columns of the data should be plotted}

\item{synth_data}{The synthetic data to be plotted}

\item{epoch}{The epoch during training for the plot title}

\item{main}{An optional plot title}
}
\value{
A function
}
\description{
Provides a function to send the output of a DataTransformer to
a torch tensor, so that it can be accessed during GAN training.
}
\examples{
\dontrun{
# Before running the first time the torch backend needs to be installed
torch::install_torch()
# Load data
data <- sample_toydata()
# Build new transformer
transformer <- data_transformer$new()
# Fit transformer to data
transformer$fit(data)
# Transform data and store as new object
transformed_data <-  transformer$transform(data)
# Train the default GAN
trained_gan <- gan_trainer(transformed_data)
# Sample synthetic data from the trained GAN
synthetic_data <- sample_synthetic_data(trained_gan, transformer)
# Plot the results
GAN_update_plot(data = data,
synth_data = synthetic_data,
main = "Real and Synthetic Data after Training")
}
}
