/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.AnsleyFilter;
import ec.tstoolkit.arima.estimation.ConcentratedLikelihoodEstimation;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.arima.estimation.ModifiedLjungBoxFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.modelling.IRobustStandardDeviationComputer;
import ec.tstoolkit.modelling.arima.AbstractSingleOutlierDetector;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class ResidualsOutlierDetector<T extends IArimaModel>
extends AbstractSingleOutlierDetector<T> {
    private IArmaFilter m_filter;
    private double[] m_el;
    private int m_n;

    public ResidualsOutlierDetector() {
        this(IRobustStandardDeviationComputer.mad());
    }

    public ResidualsOutlierDetector(IRobustStandardDeviationComputer computer) {
        this(computer, null);
    }

    public ResidualsOutlierDetector(IRobustStandardDeviationComputer computer, IArmaFilter filter) {
        super(computer);
        this.m_filter = filter == null ? new AnsleyFilter() : filter;
    }

    @Override
    protected boolean calc() {
        RegModel dmodel = this.getModel().getDModel();
        this.m_n = this.m_filter.initialize((IArimaModel)this.getModel().getArma(), dmodel.getObsCount());
        if (!this.initialize(dmodel)) {
            return false;
        }
        for (int i = 0; i < this.getOutlierFactoriesCount(); ++i) {
            this.processOutlier(i);
        }
        return true;
    }

    protected boolean initialize(RegModel model) {
        try {
            ConcentratedLikelihoodEstimation estimation = new ConcentratedLikelihoodEstimation();
            if (!estimation.estimate(this.getModel())) {
                return false;
            }
            this.m_el = estimation.getResiduals();
            this.getStandardDeviationComputer().compute(new ReadDataBlock(this.m_el));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected void processOutlier(int idx) {
        int n = this.getModel().getY().getLength();
        int d = this.getModel().getDifferencingFilter().getDegree();
        double[] o = new double[2 * n];
        DataBlock O = new DataBlock(o);
        TsPeriod start = this.getDomain().getStart();
        IOutlierVariable outlier = this.getOutlierFactory(idx).create(start.firstday());
        outlier.data(start.minus(n), O);
        double[] od = new double[o.length - d];
        DataBlock OD = new DataBlock(od);
        this.getModel().getDifferencingFilter().filter(O, OD);
        DataBlock OL = new DataBlock(od, n, 2 * n - d, 1);
        for (int i = 0; i < n; ++i) {
            if (this.isDefined(i, idx)) {
                double[] u = new double[this.m_n];
                DataBlock U = new DataBlock(u);
                this.m_filter.filter(OL, U);
                double xx = 0.0;
                double xy = 0.0;
                for (int j = 0; j < u.length; ++j) {
                    xx += u[j] * u[j];
                    xy += u[j] * this.m_el[j];
                }
                if (xx <= 0.0) {
                    this.exclude(i, idx);
                } else {
                    this.setT(i, idx, xy / Math.sqrt(xx) / this.getMAD());
                    this.setCoefficient(i, idx, xy / xx);
                }
            }
            OL.move(-1);
        }
    }

    protected DataBlock filter(DataBlock res) {
        ModifiedLjungBoxFilter f = new ModifiedLjungBoxFilter();
        Object arma = this.getModel().getArma();
        int nf = f.initialize((IArimaModel)arma, res.getLength());
        DataBlock fres = new DataBlock(nf);
        f.filter(res, fres);
        return fres.drop(nf - this.getModel().getDModel().getObsCount(), 0);
    }

    @Override
    protected void clear(boolean all) {
        super.clear(all);
    }
}

