% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilPseudoValues.R
\name{UtilPseudoValues}
\alias{UtilPseudoValues}
\title{Pseudovalues for given dataset and FOM}
\usage{
UtilPseudoValues(dataset, FOM, FPFValue = 0.2)
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \code{\link{RJafroc-package}};
must be factorial, or split-plot-a or split-plot-c.}

\item{FOM}{The figure of merit to be used in the calculation. 
The default is \code{"FOM_wAFROC"}. See \code{\link{UtilFigureOfMerit}}.}

\item{FPFValue}{Only needed for \code{LROC} data \strong{and} FOM = "PCL" or "ALROC";
where to evaluate a partial curve based figure of merit. The default is 0.2.}
}
\value{
A list containing two arrays containing the pseudovalues
   and the jackknife FOM values of the datasets (a third returned value 
   is for internal use).
}
\description{
Returns \strong{centered} jackknife pseudovalues AND jackknife FOM values, 
   for factorial OR split-plot-a OR split-plot-c study designs
}
\note{
Each returned array has dimension \code{c(I,J,K)}, where \code{K} depends on the
   FOM: \code{K1} for FOMs that are based on normal cases only, \code{K2} for FOMs that are 
   based on abnormal cases only, and \code{K} for FOMs that are based on normal and 
   abnormal cases.
}
\examples{
UtilPseudoValues(dataset05, FOM = "wAFROC")$jkFomValues[1,1,1:10]

}
