% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/26_jalalidate_other_functions.R
\name{is_valid_date_elements}
\alias{is_valid_date_elements}
\title{validation JalaliDate elements}
\usage{
is_valid_date_elements(year, month, day, ...)
}
\arguments{
\item{year}{double}

\item{month}{double}

\item{day}{double}

\item{...}{passing options ("MIN_YEAR" and/or "MAX_YEAR") to override package options (\link{jdopt_get_options})}
}
\value{
list of validation result and related message
}
\description{
check validation of Jalali date elements and returns results
}
\details{
type of message are:
\itemize{
 \item{"y": year is not valid}
 \item{"m": month is not valid}
 \item{"d1": day must be between 0 to 31}
 \item{"d2": in the last 6 months of the year, the day should not be more than 30}
 \item{"d3": in leap years, the day should not be 30}
}
}
\examples{
is_valid_date_elements(c(1402, 1000), c(12, 13), c(10, 11), MIN_YEAR=100)
# $result
# [1]  TRUE FALSE
#
# $message
# [1] ""  "m"
}
