% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sandwich.R
\name{Sandwich}
\alias{Sandwich}
\title{Calculating standard error of estimate.}
\usage{
Sandwich(
  eta_wo_k,
  gamma,
  Attr,
  Choice_Set_List,
  Alts_Same_Choice_Set,
  Is_Purchase,
  Base_Prod,
  Num_Prod,
  Num_Attr,
  H,
  cond
)
}
\arguments{
\item{eta_wo_k}{numeric, estimated model parameters normalized for baseline product.}

\item{gamma}{numeric, estimated gamma(no-purchase utility).}

\item{Attr}{list, a set of data frame in which alternative specific variables.}

\item{Choice_Set_List}{list, product code included for each choice set.}

\item{Alts_Same_Choice_Set}{list, for internal calculation, a list of data exposed to the same choice set.}

\item{Is_Purchase}{list, for internal calculation, list of customers who are
exposed to the same choice set who purchased the product. If purchased 1, otherwise 0.}

\item{Base_Prod}{numeric, the baseline product number}

\item{Num_Prod}{numeric, the number of all products in observed data.}

\item{Num_Attr}{numeric, the number of attributes in observed data.}

\item{H}{matrix, a hessian matrix of the log-likelihood function.}

\item{cond}{numeric, the value associated with prop, which is the argument of the \code{\link{rmm}} function. (1-prop)/prop.}
}
\value{
a value of standard error of estimate.
}
\description{
Calculating statndard error of model parameters and gamma(no-purchase utility). Internal function that users should not call directly.
}
\keyword{internal}
