% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{plot_sample_clustering}
\alias{plot_sample_clustering}
\title{Plot clustering of samples in a distance heatmap}
\usage{
plot_sample_clustering(
  se,
  n_feats = 500,
  anno_vars = NULL,
  anno_title = "group",
  distance = "euclidean",
  ...
)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{n_feats}{Number of top-variable features (genes) to consider}

\item{anno_vars}{Character vector of columns in \code{colData(se)} to annotate samples}

\item{anno_title}{The title of the color legend for \code{anno_vars}}

\item{distance}{The type of distance metric to consider. Either 'euclidean', 'pearson' or 'spearman'}

\item{...}{Other arguments passed on to ComplexHeatmap::Heatmap()}
}
\value{
A Heatmap-class object of the \code{ComplexHeatmap} package that contains the heatmap of pairwise sample distances.
}
\description{
Plot clustering of samples in a distance heatmap
}
\examples{
\donttest{
library("DESeq2")
dds <- makeExampleDESeqDataSet(m=8, interceptMean=10)
vsd <- vst(dds)
plot_sample_clustering(vsd)
}
}
