% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODBCConnection.R, R/ODBCResult.R
\docType{methods}
\name{dbSendQuery,ODBCConnection-method}
\alias{dbClearResult,ODBCResult-method}
\alias{dbFetch,ODBCResult-method}
\alias{dbHasCompleted,ODBCResult-method}
\alias{dbSendQuery,ODBCConnection-method}
\title{Execute a statement on a given database connection.}
\usage{
\S4method{dbSendQuery}{ODBCConnection}(conn, statement, ...)

\S4method{dbFetch}{ODBCResult}(res, n = -1, ...)

\S4method{dbHasCompleted}{ODBCResult}(res, ...)

\S4method{dbClearResult}{ODBCResult}(res, ...)
}
\arguments{
\item{conn}{An existing \code{\linkS4class{ODBCConnection}}}

\item{statement}{The SQL which you want to run}

\item{...}{Other parameters passed on to methods}

\item{res}{An object of class \code{\linkS4class{ODBCResult}}}

\item{n}{Number of rows to return. If less than zero returns all rows.}
}
\description{
To retrieve results a chunk at a time, use \code{dbSendQuery},
\code{dbFetch}, then \code{ClearResult}. Alternatively, if you want all the
results (and they'll fit in memory) use \code{dbGetQuery} which sends,
fetches and clears for you.
}

