% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpygeo_reticulate.R
\name{rpygeo_search}
\alias{rpygeo_search}
\title{Search for ArcPy functions and classes}
\usage{
rpygeo_search(search_term = NULL)
}
\arguments{
\item{search_term}{Search term. Regular expressions are possible.}
}
\value{
Named list of character vectors of matching ArcPy functions and classes
}
\description{
Search for ArcPy functions and classes with a character string or regular expression.
}
\details{
The list members are referenced by the ArcPy module names. Each
member contains a character vector of matching ArcPy functions and classes.
Except for the main module, functions and classes have to be accessed by their
module names (s. examples).
}
\examples{

\dontrun{
# Load packages
library(RPyGeo)
library(magrittr)
library(RQGIS)

# Get data
data(dem, package = "RQGIS")

# Write data to disk
writeRaster(dem, file.path(tempdir(), "dem.tif"), format = "GTiff")

# Load the ArcPy module and build environment
arcpy <- rpygeo_build_env(overwrite = TRUE,
                          workspace = tempdir(),
                          extensions = "Spatial")

# Search for ArcPy functions, which contain the term slope
rpygeo_search("slope")

#> $toolbox
#> [1] "Slope_3d"        "SurfaceSlope_3d"
#>
#> $main
#> [1] "Slope_3d"        "SurfaceSlope_3d"
#>
#> $sa
#> [1] "Slope"
#>
#> $ddd
#> [1] "Slope"        "SurfaceSlope"

# Run function from sa module
arcpy$sa$Slope(in_raster="dem.tif")

# Run function from main module
arcpy$Slope_3d(in_raster="dem.tif")
}
}
\author{
Marc Becker
}
