% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_end_of_line}
\alias{rx_end_of_line}
\title{Match the expression only if it appears till the end of the line.}
\usage{
rx_end_of_line(.data = NULL, enable = TRUE)
}
\arguments{
\item{.data}{Expression to match, typically pulled from the pipe \code{\%>\%}}

\item{enable}{Whether to enable this behavior, defaults to \code{TRUE}}
}
\description{
Control whether to match the expression only if it appears till
the end of the line. Basically, append a \code{$} to the end of the
expression. The dollar sign is considered an \emph{anchor} and matches the
position of characters. It can be used to "anchor" the regex match at a
certain position, in this case the dollar sign matches right after the last
character in the string.
}
\examples{
rx_end_of_line(enable = TRUE)
rx_end_of_line(enable = FALSE)
rx_end_of_line("abc", enable = TRUE)

# create expression
x <- rx() \%>\%
  rx_start_of_line(FALSE) \%>\%
  rx_find("apple") \%>\%
  rx_end_of_line()

grepl(x, "apples") # should be false
grepl(x, "apple")  # should be true

}
\references{
Anchors: \url{https://www.regular-expressions.info/anchors.html}
}
