% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{damerau_levenshtein_similarity}
\alias{damerau_levenshtein_similarity}
\title{Damerau-Levenshtein Similarity}
\usage{
damerau_levenshtein_similarity(s1, s2, score_cutoff = 0L)
}
\arguments{
\item{s1}{A string. The first input string.}

\item{s2}{A string. The second input string.}

\item{score_cutoff}{An optional minimum threshold for the similarity score. Defaults to 0.}
}
\value{
The Damerau-Levenshtein similarity as an integer.
}
\description{
Calculate the Damerau-Levenshtein similarity between two strings.

Computes the similarity based on the Damerau-Levenshtein metric, which considers transpositions in addition
to substitutions, insertions, and deletions.
}
\examples{
damerau_levenshtein_similarity("abcdef", "abcfde")
damerau_levenshtein_similarity("abcdef", "abcfde", score_cutoff = 3)
}
