% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Raquifer_package.R
\name{aquifer_predict}
\alias{aquifer_predict}
\title{Generic function for cumulative water influx predictions}
\usage{
aquifer_predict(aquifer_lst, time_lst)
}
\arguments{
\item{aquifer_lst}{a list object of class 'aquifer'}

\item{time_lst}{a list object of class 'time'}
}
\value{
a data frame of cumulative water influx estimates according to the class of 'aquifer_lst' and 'time_lst' objects
}
\description{
Generate a data frame of cumulative water influx estimates according to the class of 'aquifer_lst' and 'time_lst' objects
}
\examples{
aquifer_time_1 <- aquifer_time(c(0:4) * 365, unit = "day")
aquifer_param_01 <- aquifer_param(input_unit = "Field", output_unit = "Field",
model = "uss", flow_type = "radial", water_drive = "edge", phi = 0.2, perm_h = 100,
h_a = 47, r_a = 2e4, r_R = 2e3, tetha = 360, mu_water = 0.34, c_water = 4e-6,
c_rock = 3e-6, pressure = c(3456, 3425, 3387, 3350, 3312))
results_01 <- aquifer_predict(aquifer_param_01, aquifer_time_1)

results_01

}
\references{
\insertRef{Yildiz2007}{Raquifer}

\insertRef{Nabor1964}{Raquifer}

\insertRef{Fetkovich1971}{Raquifer}

\insertRef{VanEverdingen1949}{Raquifer}
}
