% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateDfuncs.R
\name{integrateDfuncs}
\alias{integrateDfuncs}
\title{Integration of distance functions}
\usage{
integrateDfuncs(object, ml)
}
\arguments{
\item{object}{Either an Rdistance fitted distance function
(an object that inherits from class "dfunc"; usually produced 
by a call to \code{\link{dfuncEstim}}), or a matrix of canonical 
distance function parameters (e.g., \code{matrix(exp(fit$par),1)}). 
If a matrix, each row corresponds to a 
distance function and each column is a parameter. The first column is 
the parameter related to sighting covariates and must be transformed 
to the "real" space (i.e., inverse link, which is \eqn{exp()}, must 
be applied outside this routine).  If \code{object} is a matrix, 
it should not have measurement units because
only derived quantities (e.g., ESW) have units; Rdistance function 
parameters themselves never have units.}

\item{ml}{Either a Rdistance 'model frame' or an Rdistance 
'fitted object'.  Both are of class "dfunc". 
Rdistance 'model frames' are lists containing components 
necessary to estimate a distance function, but no estimates. 
Rdistance 'model frames' are typically
produced by calls to \code{\link{parseModel}}. 
Rdistance 'fitted objects'
are typically produced by calls to \code{\link{dfuncEstim}}.
'Fitted objects' are 'model frames'
with additional components such as the parameters estimates, 
log likelihood value, convergence information, and the variance-
covariance matrix of the parameters.}
}
\value{
A vector of areas under the distance functions represented in 
\code{object}. 
If \code{object} is a distance function and 
\code{newdata} is specified, the returned vector's length is 
\code{nrow(newdata)}.  If \code{object} is a distance function and 
\code{newdata} is NULL, 
returned vector's length is \code{length(distances(object))}. If 
\code{object} is a matrix, return's length is 
\code{nrow(object)}.
}
\description{
Integrates under distances functions using exact integrals 
when possible.  If exact integrals are not known, numerical 
integration is used.
}
\details{
Let K be the integral under distance function g(x) (i.e., the output
from this routine). In distance analysis, the observation likelihood 
being evaluated for maximization 
is the \emph{density}, f(x) = g(x)/K.  K is a key quantity in distance 
analysis and is called the "effective sampling distance".
}
\section{Note}{

Users will not normally call this function. It is called 
internally by \code{\link{nLL}} and \code{\link{effectiveDistance}}.
}

\examples{
# Faking a model frame
ml <- list( likelihood = "halfnorm"
          , expansions = 0
          , w.lo = 0 \%m\% .
          , w.hi = 100 \%m\% .
          , Units = "m"
          )
attr(ml, "transType") <- "line"

parms <- matrix(75, nrow = 1) 
integrateDfuncs(parms, ml)

# check: Normal, 0 to 100, sd = 75, scaled to mode = 1
(pnorm(q = 100, mean = 0, sd = 75) - 0.5) * sqrt(2*pi)*75

}
