% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devices.R
\name{devices}
\alias{devices}
\alias{devices_list}
\alias{devices_show}
\alias{devices_get_events}
\alias{devices_get_properties}
\title{Devices API methods}
\usage{
devices_list(
  serial = NULL,
  tags = NULL,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

devices_show(device_id, store_token = "option", token = NULL, silent = FALSE)

devices_get_events(
  device_id,
  limit = NULL,
  start = NULL,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

devices_get_properties(
  device_id,
  show_deleted = FALSE,
  store_token = "option",
  token = NULL,
  silent = FALSE
)
}
\arguments{
\item{serial}{serial number of the device you  may want to filter from the list (not device_id)}

\item{tags}{tags you  may want to filter from the list}

\item{store_token}{Where your token is stored. If \code{option} it will be retrieved from the .Rprofile (not cross-session and default),
if \code{envir} it will be retrieved from environmental variables list (cross-session)}

\item{token}{A valid token created with \code{create_auth_token} or manually.
It not \code{NULL} it has higher priority then \code{store_token}}

\item{silent}{Whether to hide or show API method success messages (default \code{FALSE})}

\item{device_id}{The id of the device (The arn of the associated device)}

\item{limit}{The number of events to select}

\item{start}{A \code{Posixct} or \code{Date} object. Time at which to start selecting events}

\item{show_deleted}{If \code{TRUE}, shows the soft deleted properties. Default to \code{FALSE}}
}
\value{
A tibble showing extensive information about devices (and related things) associated to the user
}
\description{
List and show devices, events, properties associated to the user

Official documentation:
\itemize{
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-DevicesV2-devicesV2List}{devicesV2List}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-ThingsV2-thingsV2Show}{thingsV2Show}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-DevicesV2-devicesV2GetEvents}{devicesV2GetEvents}
}
}
\examples{
\dontrun{
library(dplyr)
Sys.setenv(ARDUINO_API_CLIENT_ID = 'INSERT CLIENT_ID HERE')
Sys.setenv(ARDUINO_API_CLIENT_SECRET = 'INSERT CLIENT_SECRET HERE')

create_auth_token()

### check properties list ###
d_list = devices_list()
device_id = d_list \%>\% slice(1) \%>\% pull(id)

devices_show(device_id = device_id)

### get device events ###
devices_get_events(device_id = device_id)

### get device properties ###
devices_get_properties(device_id = device_id)

}
}
