% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_model.R
\name{guess_constraints}
\alias{guess_constraints}
\title{Guess \link{RelDataModel} constraints based on the provided or existing tables}
\usage{
guess_constraints(
  x,
  data = NULL,
  env = parent.frame(n = 1),
  constraints = c("unique", "not nullable", "foreign keys")
)
}
\arguments{
\item{x}{a \link{RelDataModel}}

\item{data}{a named list of tables. All names of x should exist in data. If
NULL, the data are taken from env.}

\item{env}{the R environment in which to find the tables}

\item{constraints}{the type of constraints to guess}
}
\value{
A \link{RelDataModel}
}
\description{
Guess \link{RelDataModel} constraints based on the provided or existing tables
}
\details{
The guessed constraints should be carefully review, especially the foreign
keys.

Complex foreign keys involving multiple fields are not guessed.
}
\examples{
## Read data files ----
to_read <- list.files(
   system.file("examples/HPO-subset", package="ReDaMoR"),
   full.names=TRUE
)
hpo_tables <- list()
for(f in to_read){
   hpo_tables[[sub("[.]txt$", "", basename(f))]] <- readr::read_tsv(f)
}
## Build the model from a list of data frames ----
new_model <- df_to_model(
   list=names(hpo_tables), envir=as.environment(hpo_tables)
)
## Guess constraints and auto layout ----
new_model <- guess_constraints(new_model, data = hpo_tables) \%>\%
   auto_layout(lengthMultiplier=250)

## Plot the model ----
new_model \%>\%
   plot()
}
