% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arco_parlamentario.R
\name{Arc_Comparacion}
\alias{Arc_Comparacion}
\title{Graphs. Comparative chart of Parliamentary Arcs}
\usage{
Arc_Comparacion(
  Partidos1,
  Partidos2,
  Escanos1,
  Escanos2,
  cols = NULL,
  repr = c("absolute", "proportion"),
  titu1 = "Election1",
  titu2 = "Election2",
  titulo = "Poner un titulo"
)
}
\arguments{
\item{Partidos1}{It is a character vector with the names of the parties of the first process.}

\item{Partidos2}{It is a character vector with the names of the parties of the second process.}

\item{Escanos1}{It is an integer vector with the results of the first process.}

\item{Escanos2}{It is an integer vector with the results of the second process.}

\item{cols}{It is a vector containing the colors to be used in the elaboration of the graph}

\item{repr}{To indicate if you want a graph in absolute terms ("absolute") or to use relative terms ("proportion").}

\item{titu1}{Title to be used for the first process}

\item{titu2}{Title to be used for the second process}

\item{titulo}{Global title for the whole chart.}
}
\value{
A ggplot object is obtained containing two graphs representing the two parliamentary arcs to be compared.
}
\description{
With this graph two parliamentary arcs will be obtained with the purpose of
being able to compare the structure of them, that is to say, the results obtained
in two different electoral processes.
}
\examples{

bt1 <- data.frame(parties = c("PP", "CSU", "SPD","IU"),
                 seats   = c(200, 46, 153,58),
                 cols    = c("black", "blue", "red","jjj"),
                 stringsAsFactors = FALSE)

bt2 <- data.frame(parties = c("PP", "CSU","UP1"),
                 seats   = c(100, 146,200),
                 cols    = c("green", "blue","GGG"),
                 stringsAsFactors = FALSE)

Arc_Comparacion(bt1$parties,bt2$parties, bt1$seats,
               bt2$seats, cols=c("PP"="blue", "CSU"="red","SPD"="green",
                                 "IU"="pink","UP1"="antiquewhite" ),
               titu1 = "Abril-2019",titu2 = "Noviembre-2019",
               titu = " ComparaciÃ³n de elecciones")

}
