% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{InjusticiaM}
\alias{InjusticiaM}
\title{utilities.Mathematical Injustice ( IM )}
\usage{
InjusticiaM(dates)
}
\arguments{
\item{dates}{It is a data.frame object that contains the information as follows:
The first column is reserved for the name of the political parties. The second column
contains the votes obtained, and the third column is used for the seats obtained by
that political party.}
}
\value{
The result is a matrix object, of dimension n x n, with n equal to the
number of parties provided in the input data.frame. The names of the rows and columns
coincide with the names of the parties provided in the input data.frame in the first column.
}
\description{
This indicator was proposed by Edward V. Huntington and measures the degree
of "injustice" in an electoral system by translating the votes obtained by political parties
into seats. In this sense, Edward V.Huntington defined this mathematical injustice
between two parties competing in an electoral process as the difference in absolute value
between the ratios of seats and votes obtained by those two political parties. That is,
for each political party the ratio between seats and votes is obtained, and the
mathematical injustice will be the difference in absolute value of those ratios.

If we express the above in a mathematical formula we get the following:

\deqn{IM_{ij}=\left|\frac{e_{i}}{v_{i}}-\frac{e_{j}}{v_{j}}\right|}{IM_ij=abs((ei/vi)-(ej/vj))}
for \eqn{i =1,  2, \ldots,n } and vi the votes of the party i and ei its seats
}
\examples{
a<- data.frame(par=c('A','B','C','D'),
              vot=c(200,300,100,24),sea=c(3,4,1,0), stringsAsFactors = FALSE)

InjusticiaM(a)
}
