% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapa.R
\name{mapa}
\alias{mapa}
\title{Graphs. Representation on maps. Choropleth map}
\usage{
mapa(
  dat,
  camino,
  titulo,
  size_letra = 3,
  color_text = "brown",
  ver_text = TRUE
)
}
\arguments{
\item{dat}{It's a data.frame with two columns. The first contains, in the case
of Spain, the INE (Spanish National Institute of Statistics) code of the provinces,
and the second the value of the variable to be represented. \strong{IMPORTANT NOTE:} It must
be taken special care with the fact that the first column is not of the factor type.
It is recommended to be character type, never use a factor.}

\item{camino}{It will be a character value to indicate where are located the files downloaded from
github containing the map data. The path must end with the character "/".}

\item{titulo}{The title to be displayed on the map will be specified here.}

\item{size_letra}{This is the font size that will be used to display the numerical
values on the map.}

\item{color_text}{It serves to indicate the color of the text that will be used to
display the data on the map.}

\item{ver_text}{It must be a Boolean value. By default it is TRUE, to
indicate that the data will be shown on the map. On the other hand, if this
parameter is set to FALSE the data values will not be displayed.}
}
\value{
Returns a ggplot2 object, containing the map to be represented
}
\description{
With this function you can make choropleth maps, to carry out
representations of the data on a map. By default, the map used is that of Spain,
but any map of another country could be used too, as long as it is of shapefile type.
\strong{NOTE:} The shapefile to be used can be downloaded from the following web page \url{https://github.com/Miguelro/Electoral/tree/master/Mapa}
and all the files will be placed in a folder, which will serve to point out the
path to be indicated in the 'camino' parameter.
}
\examples{

d <-data.frame(
cod=c(1,2,5,9,15,23,43,50),
da = c(3,5,7,10,1,3,80,4)
)
suppressWarnings(mapa(d,system.file("maps/", package="Relectoral"),
                     titulo="An example map and some NA values",ver_text = TRUE))


}
