test_that("Output of function 'powerSignificanceInterim' stays the same.", {
    # set all possible parameters
    grid <- expand.grid(
        zo = seq(-4, 4, length.out = 2L),
        zi = seq(0, 4, length.out = 2L),
        c = c(0, 10), # c = 0 is allowed
        f = c(0, 1), # This function actually allows 0 and 1
        level = c(1e-4, 0.9999),
        designPrior = c("conditional", "informed predictive", "predictive"),
        analysisPrior = c("flat", "original"),
        alternative = c("one.sided", "two.sided"),
        shrinkage = c(0, 0.9999),
        stringsAsFactors = FALSE
    )
    out <- lapply(
        seq_len(nrow(grid)),
        function(i) {
            tryCatch({
                powerSignificanceInterim(
                    zo = grid[i, "zo"],
                    zi = grid[i, "zi"],
                    c = grid[i, "c"],
                    f = grid[i, "f"],
                    level = grid[i, "level"],
                    designPrior = grid[i, "designPrior"],
                    analysisPrior = grid[i, "analysisPrior"],
                    alternative = grid[i, "alternative"],
                    shrinkage = grid[i, "shrinkage"]
                )
            },
            warning = function(w) "warning!",
            error = function(e) "error!"
            )
        }
    )
    res <- list(
        1e-04, 1e-04, 1e-04, 1e-04, 1, 1, 1, 1, NaN, NaN, 0, NaN,
        NaN, NaN, 0, NaN, 0.9999, 0.9999, 0.9999, 0.9999, 1, 1, 1,
        1, NaN, NaN, NaN, 1, NaN, NaN, NaN, 1, 1e-04, 1e-04, 1e-04,
        1e-04, 0.996454335824637, 0.996454335824637, 0.996454335824637,
        0.996454335824637, NaN, NaN, 0, NaN, NaN, NaN, 0, NaN, 0.9999,
        0.9999, 0.9999, 0.9999, 0.999999599607466, 0.999999599607466,
        0.999999599607466, 0.999999599607466, NaN, NaN, NaN, 1, NaN,
        NaN, NaN, 1, 0.5, 0.5, 3.16712418331199e-05, 0.999968328758167,
        0.5, 0.5, 3.16712418331199e-05, 0.999968328758167, 0, 0,
        0, 1, 0, 0, 0, 1, 0.5, 0.5, 3.16712418331199e-05, 0.999968328758167,
        0.5, 0.5, 3.16712418331199e-05, 0.999968328758167, 1, 1,
        0, 1, 1, 1, 0, 1, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NaN, NaN, NaN, NaN, 0.998732696844615,
        0.998732696844615, 0.998732696844615, 0.998732696844615,
        NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, 1, 1, 1, 1, 0.999999960912676,
        0.999999960912676, 0.999999960912676, 0.999999960912676,
        NaN, NaN, NaN, 1, NaN, NaN, NaN, 1, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 4.99999999999999e-05,
        4.99999999999999e-05, 4.99999999999999e-05, 4.99999999999999e-05,
        1, 1, 1, 1, NaN, NaN, 0, NaN, NaN, NaN, 0, NaN, 0.49995,
        0.49995, 0.49995, 0.49995, 1, 1, 1, 1, NaN, NaN, 0, NaN,
        NaN, NaN, 0, NaN, 4.99999999999999e-05, 4.99999999999999e-05,
        4.99999999999999e-05, 4.99999999999999e-05, 0.995864385237383,
        0.995864385237383, 0.995864385237383, 0.995864385237383,
        NaN, NaN, 0, NaN, NaN, NaN, 0, NaN, 0.49995, 0.49995, 0.49995,
        0.49995, 0.999931580367731, 0.999931580367731, 0.999931580367731,
        0.999931580367731, NaN, NaN, 0, NaN, NaN, NaN, 0, NaN, 0.5,
        0.5, 3.16712418331199e-05, 0.999968328758167, 0.5, 0.5, 3.16712418331199e-05,
        0.999968328758167, 0, 0, 0, 1, 0, 0, 0, 1, 0.5, 0.5, 3.16712418331199e-05,
        0.999968328758167, 0.5, 0.5, 3.16712418331199e-05, 0.999968328758167,
        0, 0, 0, 1, 0, 0, 0, 1, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NaN, NaN, NaN, NaN, 0.998486202630801,
        0.998486202630801, 0.998486202630801, 0.998486202630801,
        NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN,
        0.999986368199156, 0.999986368199156, 0.999986368199156,
        0.999986368199156, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, 1e-04, 1e-04, 1e-04, 1e-04, 0.000100501891919886,
        0.000100501891919886, 0.000100501891919886, 0.000100501891919886,
        NaN, NaN, 0, NaN, NaN, NaN, 0, NaN, 0.9999, 0.9999, 0.9999,
        0.9999, 0.999900499536452, 0.999900499536452, 0.999900499536452,
        0.999900499536452, NaN, NaN, NaN, 1, NaN, NaN, NaN, 1, 1e-04,
        1e-04, 1e-04, 1e-04, 0.131155791344669, 0.131155791344669,
        0.131155791344669, 0.131155791344669, NaN, NaN, 0, NaN, NaN,
        NaN, 0, NaN, 0.9999, 0.9999, 0.9999, 0.9999, 0.869006490156984,
        0.869006490156984, 0.869006490156984, 0.869006490156984,
        NaN, NaN, NaN, 1, NaN, NaN, NaN, 1, 0.5, 0.5, 3.16712418331199e-05,
        0.999968328758167, 0.5, 0.5, 3.16712418331199e-05, 0.999968328758167,
        0, 0, 0, 1, 0, 0, 0, 1, 0.5, 0.5, 3.16712418331199e-05, 0.999968328758167,
        0.5, 0.5, 3.16712418331199e-05, 0.999968328758167, 1, 1,
        0, 1, 1, 1, 0, 1, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NaN, NaN, NaN, NaN, 0.119870031456711,
        0.119870031456711, 0.119870031456711, 0.119870031456711,
        NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, 1, 1, 1, 1, 0.88029760104854,
        0.88029760104854, 0.88029760104854, 0.88029760104854, NaN,
        NaN, NaN, 1, NaN, NaN, NaN, 1, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 4.99999999999999e-05,
        4.99999999999999e-05, 4.99999999999999e-05, 4.99999999999999e-05,
        5.02613035071984e-05, 5.02613035071984e-05, 5.02613035071984e-05,
        5.02613035071984e-05, NaN, NaN, 0, NaN, NaN, NaN, 0, NaN,
        0.49995, 0.49995, 0.49995, 0.49995, 0.500454626405874, 0.500454626405874,
        0.500454626405874, 0.500454626405874, NaN, NaN, 0, NaN, NaN,
        NaN, 0, NaN, 4.99999999999999e-05, 4.99999999999999e-05,
        4.99999999999999e-05, 4.99999999999999e-05, 0.120462838372521,
        0.120462838372521, 0.120462838372521, 0.120462838372521,
        NaN, NaN, 0, NaN, NaN, NaN, 0, NaN, 0.49995, 0.49995, 0.49995,
        0.49995, 0.500137075045887, 0.500137075045887, 0.500137075045887,
        0.500137075045887, NaN, NaN, 0, NaN, NaN, NaN, 0, NaN, 0.5,
        0.5, 3.16712418331199e-05, 0.999968328758167, 0.5, 0.5, 3.16712418331199e-05,
        0.999968328758167, 0, 0, 0, 1, 0, 0, 0, 1, 0.5, 0.5, 3.16712418331199e-05,
        0.999968328758167, 0.5, 0.5, 3.16712418331199e-05, 0.999968328758167,
        0, 0, 0, 1, 0, 0, 0, 1, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NaN, NaN, NaN, NaN, 0.109368464869468,
        0.109368464869468, 0.109368464869468, 0.109368464869468,
        NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN,
        0.50015155428545, 0.50015155428545, 0.50015155428545, 0.50015155428545,
        NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA
    )
    expect_equal(out, res)
})
