% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fssaplot.R
\name{plot.fssa}
\alias{plot.fssa}
\title{Plot Functional Singular Spectrum Analysis Objects}
\usage{
\method{plot}{fssa}(
  x,
  d = length(x$values),
  idx = 1:d,
  idy = idx + 1,
  contrib = TRUE,
  groups = as.list(1:d),
  lwd = 2,
  type = "values",
  vars = NULL,
  ylab = NA,
  main = NA,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{fssa}}.}

\item{d}{An integer representing the number of elementary components to plot.}

\item{idx}{A vector of indices specifying which eigen elements to plot.}

\item{idy}{A second vector of indices of eigen elements to plot (for \code{type="paired"}).}

\item{contrib}{A logical value. If \code{TRUE} (default), it displays the component's contribution to the total variance.}

\item{groups}{A list or vector of indices determining the grouping used for decomposition (for \code{type="wcor"}).}

\item{lwd}{A vector of line widths.}

\item{type}{The type of plot to be displayed. Possible types include:
\itemize{
  \item \code{"values"} - Plot the square-root of eigen values (default).
  \item \code{"paired"} - Plot pairs of right singular function's coefficients (useful for detecting periodic components).
  \item \code{"wcor"} - Plot the W-correlation matrix for the reconstructed objects.
  \item \code{"vectors"} - Plot the right singular vectors (useful for detecting period length).
  \item \code{"lcurves"} - Plot left singular functions (useful for detecting period length).
  \item \code{"lheats"} - Heatmap plot of eigenfunctions, usable for \code{\link{funts}} variables observed over one or two-dimensional domains (useful for detecting meaningful patterns).
  \item \code{"periodogram"} - Periodogram plot right singular vectors (useful for detecting the frequencies of oscillations in functional data).
}}

\item{vars}{A numeric value specifying the variable number (used in plotting MFSSA \code{"lheats"} or \code{"lcurves"}).}

\item{ylab}{A character vector representing the names of variables.}

\item{main}{The main plot title.}

\item{...}{Additional arguments to be passed to methods, such as graphical parameters.}
}
\description{
This function is a plotting method for objects of class functional singular spectrum analysis (\code{\link{fssa}}).
It aids users in making decisions during the grouping stage of univariate or multivariate functional singular spectrum analysis.
}
\examples{
data("Callcenter")
L <- 28
U <- fssa(Callcenter, L)
plot(U, type = "values", d = 10)
plot(U, type = "vectors", d = 4)
plot(U, type = "paired", d = 6)
plot(U, type = "lcurves", d = 4, vars = 1)
plot(U, type = "lheats", d = 4)
plot(U, type = "wcor", d = 10)


}
\seealso{
\code{\link{fssa}}, \code{\link{plotly_funts}}
}
