% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ricrt.R
\name{Ricrt}
\alias{Ricrt}
\title{Ricrt}
\usage{
Ricrt(
  S,
  C,
  Z,
  R,
  X = NULL,
  tau_hyp = 0,
  method = "W",
  reg = "lm",
  permutation = 100
)
}
\arguments{
\item{S}{A numeric column vector with individuals' stratum number}

\item{C}{A numeric column vector with individuals' cluster number}

\item{Z}{A numeric column vector with individuals' treatment assignment
(binary)}

\item{R}{A numeric column vector with individuals' outcome}

\item{X}{A numeric matrix with each column being a covariate}

\item{tau_hyp}{A numeric value for hypothesized treatment effect,
the default for this value is 0.}

\item{method}{A string being either "W" or "sr", indicating either
weighted sum of S Mann–Whitney–Wilcoxon statistics will be used or
signed-rank test will be used}

\item{reg}{A string being either "lm" or "rf," indicating either
linear model or random forest model being used for fitting the data with
covariates. The default is "lm."}

\item{permutation}{A numeric value indicating the number of permutation
inside the function when using permutation tests for p-values,
the default is 50.}
}
\value{
A list of the outputs
}
\description{
This package can use Mann-Whitney-Wilcoxon or signed-rank test to perform
randomization inference. The statistics, p-value, point estimation, and a
two-sided 95% confidence interval will be returned.
}
\examples{
# First we need to obtain the vectors for the inputs.
S = example1$S
C = example1$C
Z = example1$Z
R = example1$R
X = cbind(example1$X1, example1$X2, example1$X3, example1$X4, example1$X5)

# Let's see the first example with method = W and reg = lm.
set.seed(123)
\donttest{Ricrt(S, C, Z, R, X, tau_hyp = 10, method = "W", reg = "lm", permutation = 5)}

# Let's see the second example with method = W and reg = rf
\donttest{Ricrt(S, C, Z, R, X, tau_hyp = 10, method = "W", reg = "rf", permutation = 5)}
}
