% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_ilostat_cache.R
\name{clean_ilostat_cache}
\alias{clean_ilostat_cache}
\title{Clean ilostat Cache}
\usage{
clean_ilostat_cache(
  cache_dir = getOption("ilostat_cache_dir", file.path(tempdir(), "ilostat")),
  cache_update = getOption("ilostat_cache_update", FALSE),
  quiet = getOption("ilostat_quiet", FALSE)
)
}
\arguments{
\item{cache_dir}{A character, path to a cache directory. The directory has to exist.
The \code{NULL} (default) uses and creates
'ilostat' directory in the temporary directory from
\code{\link{tempdir}}. The directory can also be set with
\code{option} ilostat_cache_dir,}

\item{cache_update}{a logical whether to delete only out of date cache files. Useful when \code{cache_dir} 
is set as keep only update datasets. Can be set also with
  options(ilostat_update = TRUE). Default is \code{FALSE}.}

\item{quiet}{a logical, if \code{TRUE} , don't return message from processing, \code{FALSE} (default).
Can be set also with options(ilostat_quiet = TRUE),}
}
\description{
Deletes all cache files from the your ilostat cache directory.
             See \code{\link{get_ilostat}} for more on cache.
}
\examples{
\dontrun{
clean_ilostat_cache() 
}
}
\references{
See citation("Rilostat")
ilostat bulk download facility user guidelines 
\url{https://webapps.ilo.org/ilostat-files/Documents/ILOSTAT_BulkDownload_Guidelines.pdf}
}
\author{
David Bescond \email{bescond@ilo.org}
}
