# RiskPortfolios

`RiskPortfolios` ([Ardia et al., 2017a](https://doi.org/10.21105/joss.00171)) is an R package for constructing risk-based portfolios dedicated to portfolio managers 
and quantitative analysts. It provides a set of functionalities to build mean-variance, minimum variance, inverse-volatility weighted, 
equal-risk-contribution, maximum diversification, and risk-efficient portfolios. As risk-based portfolios are
mainly based on covariances, the package also provides a large set of covariance matrix estimators. See [Ardia et al. (2017b)](https://doi.org/10.1007/s10479-017-2474-7) for details.

## Please cite the package in publications!

By using `RiskPortfolios` you agree to the following rules: 

1) You must cite [Ardia et al. (2017a)](https://doi.org/10.21105/joss.00171) in working papers and published papers that use `RiskPortfolios`.
2) You must place the following URL in a footnote to help others find `RiskPortfolios`: [https://CRAN.R-project.org/package=RiskPortfolios](https://CRAN.R-project.org/package=RiskPortfolios). 
3) You assume all risk for the use of `RiskPortfolios`.

Ardia, D., Boudt, K., Gagnon-Fleury, J.-P. (2017a).      
RiskPortfolios: Computation of risk-based portfolios in R.        
_Journal of Open Source Software_, 10(2), 1.    
[https://doi.org/10.21105/joss.00171](https://doi.org/10.21105/joss.00171)  

Ardia, D., Bolliger, G., Boudt, K., Gagnon-Fleury, J.-P. (2017b).      
The impact of covariance misspecification in risk-based portfolios.  
_Annals of Operations Research_, 254(1-2), 1-16.      
[https://doi.org/10.1007/s10479-017-2474-7](https://doi.org/10.1007/s10479-017-2474-7)       
[https://doi.org/10.2139/ssrn.2650644](https://doi.org/10.2139/ssrn.2650644)