% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findSurface.R
\name{findSurface}
\alias{findSurface}
\alias{splitImgHoriz}
\title{Find the surface level and split images}
\usage{
findSurface(
  img_path = NULL,
  img = NULL,
  surface_col = "red",
  pos_highpoint_px = "center",
  radius_highpoint_px = 10,
  angle = 45,
  top_side = "left",
  ppcm = NULL,
  ppi = NULL,
  return_all_results = FALSE
)

splitImgHoriz(img, surface_col = "red", return_all_results = FALSE)
}
\arguments{
\item{img_path}{(Optional, default = NULL) Character vector specifying
the image path of interest. This is only used if
\code{img} is set to NULL.}

\item{img}{Image (e.g., provided by the RootDetector) in the form of an
array with 3 dimensions for the RGB color channels (3 layers each containing
a 2-dim. numeric matrix with values between 0 and 1).}

\item{surface_col}{Color of the area to be split of the mask (default "red").
Can be of any of the three kinds of R color specifications, i.e., either a
color name (as listed by colors()), a hexadecimal string (see Details), or a
positive integer (indicates using palette()).}

\item{pos_highpoint_px}{Either one of "center" or "edge" (default),
indicating that scanning starts at the bottom or top facing side of the
minirhizotron, respectively, or it can also be an integer value (>=1 and
<=width of the \code{top_side} of the image) specifying where (left<->right)
in the top row of the image the highest point of the image lies, indicating
the column where the minimum points of the depth-level lines lie. \cr
"edge" is equivalent to using 1 or width of the \code{top_side} and
"center" to using half the width of the \code{top_side}.}

\item{radius_highpoint_px}{The radius specifying how large the are should be
to determine the split (default 10).}

\item{angle}{Numeric value >=0 and <=90 (default 45) specifying the
installation angle of the minirhizotron in degrees (angle between the ground
and the tube above the soil).}

\item{top_side}{One of "left","top" (default),"right","bottom". Indicates
where the upper side of the image is.}

\item{ppcm}{Numeric value specifying how many pixels there are per
centimeter (resolution of the image). Default NULL.
If \code{ppcm} is not NULL or NA, \code{ppi} is ignored.\cr
Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
72 ppi (screens) is 28 ppcm.}

\item{ppi}{Numeric value specifying how many pixels there are per inch
(resolution of the image). Default NULL.
Leave/set \code{ppcm} to NULL or NA to use \code{ppi}.\cr
Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
72 ppi (screens) is 28 ppcm.}

\item{return_all_results}{Specify if all checked overlaps with their
respective correlation score should be returned (default FALSE).}
}
\value{
\code{findSurface} A list with following features:
'pos_surf_px' and 'depth_highpoint_cm'.
If \code{return_all_results} is set to true, a list also comprises a matrix
'split_info' containing the information on all possible splits.

\code{splitImgHoriz} An integer value. The row where the upper
"surface" part of the image starts (the row included). Called 'pos_surf_px'
in the return value of the function \code{findSurface()}.
If \code{return_all_results} is set to true, a list containing this best
value 'best_split' as well as a matrix 'split_info' containing the
information on all possible splits is returned instead.
}
\description{
\code{findSurface} - This function finds the best split of an image with a
horizontal or vertical line into one color (often red, e.g., for the
surface) and other colors (often black and white, e.g., for everything in
the ground). This works for any images. For the application on
minirhizotron root scans the function provides the additional functionality
of using the installation angle of the minirhizotron and the resolution of
the image to not only return the position of the line in pixels, but also
the corresponding depth in cm of the highest point of the top side of the
image, also called \code{depth_highpoint_cm} in other function of this
package.

\code{splitImgHoriz} - This function finds the best split of an image with a
horizontal line into one color on the top half (often red, e.g., for the
surface) and other colors on the bottom half (often black and white, e.g.,
for everything in the ground). This works for any images.\cr
Currently, the best split is determined as the one where there are the most
equal mismatches on both sides, i.e., the same number of pixels in the top
part of the image which have not the specified color as pixels in the bottom
part of the image which have this specific color.
}
\examples{
# Example of finding the best row to horizontally split the image at the
# highpoint position.
mat_R <- matrix(c(1,1,1,1,1,
                  0,1,1,1,1,
                  0,0,1,1,1), ncol = 5, nrow = 3, byrow = TRUE)
mat_G <- matrix(c(0,0,0,0,1,
                  0,1,0,0,1,
                  0,0,1,1,1), ncol = 5, nrow = 3, byrow = TRUE)
mat_B <- matrix(c(0,0,0,0,1,
                  0,1,0,0,1,
                  0,0,1,1,1), ncol = 5, nrow = 3, byrow = TRUE)
findSurface(img = array(c(mat_R,mat_G,mat_B), dim = c(dim(mat_R),3)),
            radius_highpoint_px = 1, top_side = "top", ppcm = 1,
            return_all_results = TRUE)
# Example of finding the best row to horizontally split the image.
# Note that the top row and one pixel in the second row is red. All others
# are either black or white.
mat_R <- matrix(c(1,1,1,1,
                  0,1,0,1,
                  0,0,1,1), ncol = 4, nrow = 3, byrow = TRUE)
mat_G <- matrix(c(0,0,0,0,
                  0,1,0,0,
                  0,0,1,1), ncol = 4, nrow = 3, byrow = TRUE)
mat_B <- matrix(c(0,0,0,0,
                  0,1,0,0,
                  0,0,1,1), ncol = 4, nrow = 3, byrow = TRUE)
splitImgHoriz(img = array(c(mat_R,mat_G,mat_B), dim = c(dim(mat_R),3)),
              return_all_results = TRUE)
}
