% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_outliers_mahalanobis.R
\name{plot_outliers_mahalanobis}
\alias{plot_outliers_mahalanobis}
\title{Plotting function for the Mahalanobis distance approach}
\usage{
plot_outliers_mahalanobis(res, x, pos_display = FALSE)
}
\arguments{
\item{res}{result of the outliers_mad function from which we want to create a plot}

\item{x}{matrix of multivariate values from which we want to compute outliers. Last column of the matrix is considered as the DV in the regression line.}

\item{pos_display}{set whether the position of outliers in the dataset should be displayed on the graph (pos_display = TRUE)
or not (pos_display = FALSE)}
}
\value{
None
}
\description{
plotting data and highlighting multivariate outliers detected with the mahalanobis distance approach
}
\details{
plotting data and highlighting multivariate outliers detected with the MCD function
Additionnally, the plot return two regression lines: the first one including all data and
the second one including all observations but the detected outliers. It allows to observe how much the outliers
influence of outliers on the regression line.
}
\examples{
#### Run plot_outliers_mahalanobis
data(Attacks)
SOC <- rowMeans(Attacks[,c("soc1r","soc2r","soc3r","soc4","soc5","soc6",
"soc7r","soc8","soc9","soc10r","soc11","soc12","soc13")])
HSC <- rowMeans(Attacks[,22:46])
res <- outliers_mahalanobis(x = cbind(SOC,HSC))
plot_outliers_mahalanobis(res, x = cbind(SOC,HSC))
# it's also possible to display the position of the multivariate outliers ion the graph
# preferably, when the number of multivariate outliers is not too high
c1 <- c(1,4,3,6,5,2,1,3,2,4,7,3,6,3,4,6)
c2 <- c(1,3,4,6,5,7,1,4,3,7,50,8,8,15,10,6)
res2 <- outliers_mahalanobis(x = cbind(c1,c2))
plot_outliers_mahalanobis(res2, x = cbind(c1,c2),pos_display = TRUE)

# When no outliers are detected, only one regression line is displayed
c3 <- c(1,4,3,6,5)
c4 <- c(1,3,4,6,5)
res3 <- outliers_mahalanobis(x = cbind(c3,c4))
plot_outliers_mahalanobis(res3,x = cbind(c3,c4))

}
\keyword{mahalanobis}
\keyword{outliers}
\keyword{plot}
