% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lagged_cov.R
\name{create_lagged_cov}
\alias{create_lagged_cov}
\title{Create lagged choice covariates}
\usage{
create_lagged_cov(choice_data, column = character(), k = 1, id = "id")
}
\arguments{
\item{choice_data}{[\code{data.frame}]\cr
Choice data in wide format, where each row represents one choice occasion.}

\item{column}{[\code{character()}]\cr
Covariate names in \code{choice_data}.}

\item{k}{[\code{integer()}]\cr
The number of lags (in units of observations), see the details.}

\item{id}{[\code{character(1)}]\cr
The name of the column in \code{choice_data} that contains unique identifier
for each decision maker.}
}
\value{
The input \code{choice_data} with the additional columns named
\code{column.k} for each element \code{column} and each number \code{k}
containing the lagged covariates.
}
\description{
This function creates lagged choice covariates from the \code{data.frame}
\code{choice_data}, which is assumed to be sorted by the choice occasions.
}
\details{
Say that \code{choice_data} contains the column \code{column}. Then, the
function call
\preformatted{
create_lagged_cov(choice_data, column, k, id)
}
returns the input \code{choice_data} which includes a new column named
\code{column.k}. This column contains for each decider (based on \code{id})
and each choice occasion the covariate faced before \code{k} choice
occasions. If this data point is not available, it is set to
\code{NA}. In particular, the first \code{k} values of \code{column.k} will
be \code{NA} (initial condition problem).
}
\examples{
choice_data <- data.frame(id = rep(1:2, each = 3), cov = LETTERS[1:6])
create_lagged_cov(choice_data, column = "cov", k = 1:2)

}
