% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_test.R
\name{train_test}
\alias{train_test}
\title{Split choice data into train and test subset}
\usage{
train_test(
  x,
  test_proportion = NULL,
  test_number = NULL,
  by = "N",
  random = FALSE
)
}
\arguments{
\item{x}{An object of class \code{RprobitB_data}.}

\item{test_proportion}{[\code{numeric(1)}]\cr
The proportion of the test subset.}

\item{test_number}{[\code{integer(1)}]\cr
The number of observations in the test subset.}

\item{by}{[\code{character(1)}]\cr
Either \code{"N"} (split by deciders) and \code{"T"} (split by occasions).}

\item{random}{[\code{logical(1)}]\cr
Build subsets randomly?}
}
\value{
A list with two objects of class \code{RprobitB_data}, named \code{"train"}
and \code{"test"}.
}
\description{
This function splits choice data into a train and a test part.
}
\examples{
### simulate choices for demonstration
x <- simulate_choices(form = choice ~ covariate, N = 10, T = 10, J = 2)

### 70\% of deciders in the train subsample,
### 30\% of deciders in the test subsample
train_test(x, test_proportion = 0.3, by = "N")

### 2 randomly chosen choice occasions per decider in the test subsample,
### the rest in the train subsample
train_test(x, test_number = 2, by = "T", random = TRUE)

}
