% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{WOE_customNum}
\alias{WOE_customNum}
\title{Custom Binning Numeric Variables}
\usage{
WOE_customNum(
  data,
  var,
  id,
  target,
  breaks,
  right_bracket = F,
  color = "#0066CC",
  plot = FALSE
)
}
\arguments{
\item{data}{Dataframe containing the target variable and desired numeric variables to be binned.}

\item{var}{A specific numeric attribute to be binned. Must be specified.}

\item{id}{The unique id variable in the dataframe. Must be specified.}

\item{target}{A binary target variable. Must be specified.}

\item{breaks}{A vector of breakpoints for the desired bins. Must be specified.}

\item{right_bracket}{Logical. Specifying whether the intervals are closed on the right or the left.}

\item{color}{A hexadecimal value representing a specific color.}

\item{plot}{Logical. The default is FALSE which does not generate the plots.}
}
\value{
A list with the following components.
\item{NewBin}{Dataframe with the binned variable.}
\item{BinWOE}{Dataframe with target, binned variable, and WOE values for the bins.}
\item{IV}{Information value of the newly binned variable.}
\item{vars}{Dataframe with binned variable, WOE values for the bins, Target Rate for each bin, and observation count for each bin.}
}
\description{
Function that bins a numeric variable based on user inputted breaks, plots the information on the new bins,
and returns a list contains a dataframe of the newly binned values and id column and more items.
}
\examples{
mydata <- ISLR::Default
mydata$ID = seq(1:nrow(mydata)) ## make the ID variable
mydata$default <- ifelse(mydata$default=="Yes", 1, 0) ## target coded with 1, 0

WC_1 <- WOE_customNum(data= mydata, var="balance", id= "ID", target = "default",
                      breaks= seq(0,3000,1000))
head(WC_1$NewBin)
head(WC_1$BinWOE)
WC_1$IV
WC_1$vars

WC_2 <- WOE_customNum(data= mydata, var="income", id= "ID", target = "default",
                      breaks=seq(0,75000, 15000))
head(WC_2$NewBin)
head(WC_2$BinWOE)
WC_2$IV
WC_2$vars
}
