SavePF <-
function(nh, g )
  {
    
      if(is.null(g$destdir)) {
          destdir=tempdir()
          message(paste('Writing output to ', destdir) )
      }
      else
      {
          destdir =  g$destdir
      }
      
    if(is.null(nh$pickfile))
      {
        message("SavePF: saving raw pix")



        if( identical(legitWPX(g$WPX),0)  ) {
          
          message("Need to click on screen, register picks (GPIX, or YPIX)", sep="\n")
        }
        else
          {
            
            twpx= g$WPX
        
            nona = which( is.na(twpx$tag) )
            
            if(length(nona)>0)
              {
                twpx = RSEIS::deleteWPX(twpx, nona)
              }
            
            PCsaveWPX(twpx, destdir=destdir )
          }
        
      }
    else
      {

        if(is.null( nh$sta))
          {
            warning("no station file")
            invisible(list(global.vars=g))
          }
        
    
        if( all(is.na( nh$sta)) )
          {
            warning("no station file")
            invisible(list(global.vars=g))
          }
    
        
        
        
        PFoutput(nh$pickfile, nh$sta,  sol=NULL, format=c(1,2), destdir=destdir  )
      }
    
    
    
    g$zloc = list(x=NULL, y=NULL)
    g$action="donothing"
    invisible(list(global.vars=g))
  }
