\name{ripper}
\alias{ripper}
\title{Rip off Event location information
}
\description{Extract Event location information following Vlocate
}
\usage{
ripper(AQ)
}
\arguments{
  \item{AQ}{event location list
}
}
\details{Extract lat-lon from event locations to track
  intermediate solutions and convergence
}
\value{2 by N matrix, lat-lon
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{plotEQ
}
\examples{


library(RSEIS)
data(GH, package='RSEIS')

g1 = GH$pickfile

data(VELMOD1D, package='RSEIS')
vel= VELMOD1D

 w1 = which(!is.na(g1$STAS$lat))
         sec = g1$STAS$sec[w1]

         N = length(sec)
         Ldat =    list(
           name = g1$STAS$name[w1],
           sec = g1$STAS$sec[w1],
           phase = g1$STAS$phase[w1],
           lat=g1$STAS$lat[w1],
           lon = g1$STAS$lon[w1],
           z = g1$STAS$z[w1],
           err= g1$STAS$err[w1],
           yr = rep(g1$LOC$yr , times=N),
           jd = rep(g1$LOC$jd, times=N),
           mo = rep(g1$LOC$mo, times=N),
           dom = rep(g1$LOC$dom, times=N),
           hr =rep( g1$LOC$hr, times=N),
           mi = rep(g1$LOC$mi, times=N) )


wstart = which.min(Ldat$sec)
        EQ = list(lat=Ldat$lat[wstart], lon=Ldat$lon[wstart], z=6, t=Ldat$sec[wstart] )
      

  AQ = Vlocate(Ldat,EQ,vel, 
      distwt = 10,
      lambdareg =100 ,
      REG = TRUE,
      WTS = TRUE,
      STOPPING = TRUE,
      tolx =   0.01,
      toly = 0.01 ,
      tolz = 0.05, maxITER = c(7,5,7,4) , RESMAX = c(0.1, 0.1),  PLOT=FALSE)


qtip = ripper(AQ)



}
\keyword{misc}
