% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csolnp.R
\name{kkt_diagnose}
\alias{kkt_diagnose}
\title{Summarize KKT Condition Diagnostics}
\usage{
kkt_diagnose(kkt, tol = 1e-08)
}
\arguments{
\item{kkt}{A named list containing numeric entries for KKT diagnostics.
Required names are \code{"kkt_stationarity"}, \code{"eq_violation"},
\code{"ineq_violation"}, \code{"dual_feas_violation"}, \code{"compl_slackness"}.}

\item{tol}{Numeric tolerance for considering a condition as "satisfied". Default is \code{1e-8}.}
}
\value{
An object of class "solnp_kkt_summary" (a data.frame with columns: condition, value, status, tol).
}
\description{
Given a list of KKT diagnostic statistics (stationarity, feasibility, complementarity, etc.),
this function prints a clear summary indicating which KKT conditions are satisfied at a specified tolerance.
}
\examples{
kkt <- list(
  kkt_stationarity = 5.828909e-06,
  eq_violation = 0,
  ineq_violation = 0,
  dual_feas_violation = 0.4380053,
  compl_slackness = 0
)
kkt_diagnose(kkt, tol = 1e-8)

}
